/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.DeveloperField;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgListener;
import com.garmin.fit.csv.MesgCSVWriterBase;
import java.io.ByteArrayOutputStream;

public class MesgDataCSVWriter
extends MesgCSVWriterBase
implements MesgListener {
    public MesgDataCSVWriter(ByteArrayOutputStream byteArrayOutputStream) {
        super(byteArrayOutputStream);
    }

    @Override
    public void onMesg(Mesg mesg) {
        String string;
        String string2;
        if (mesg.getName().equals("unknown") && this.hideUnknownData) {
            return;
        }
        if (this.removeExpandedFields) {
            mesg.removeExpandedFields();
        }
        if (this.preserveGaps) {
            this.clearMesgFields(mesg);
        }
        for (Field fieldBase : mesg.getFields()) {
            if (this.hideUnknownData && fieldBase.getName().equals("unknown")) continue;
            int n = mesg.getActiveSubFieldIndex(fieldBase.getNum());
            string2 = null;
            if (null == string2) {
                string2 = this.getValueString(fieldBase, n);
            }
            string = mesg.getName() + "." + fieldBase.getName(n);
            String string3 = this.formatUnits(fieldBase.getUnits(n), fieldBase.getProfileType().name());
            if (!string3.isEmpty()) {
                string = string + "[" + string3 + "]";
            }
            this.csv.set(string, string2);
        }
        for (DeveloperField developerField : mesg.getDeveloperFields()) {
            if (!developerField.isDefined() && this.hideUnknownData) continue;
            String string4 = this.getValueString(developerField, 65535);
            string2 = mesg.getName() + ".developer." + developerField.getDeveloperDataIndex() + "." + developerField.getName();
            string = this.formatUnits(developerField.getUnits());
            if (string != null && !string.isEmpty()) {
                string2 = string2 + "[" + string + "]";
            }
            this.csv.set(string2, string4);
        }
        this.csv.writeln();
    }

    public void setMaxNumFields(int n) {
        this.csv.setMaxNumberValues(n);
    }

    public void clearMesgFields(Mesg mesg) {
        String string = mesg.getName();
        for (String string2 : this.csv.getHeaders()) {
            String string3 = string2.substring(0, string2.indexOf("."));
            if (!string3.equals(string)) continue;
            this.csv.set(string2, "");
        }
    }
}

