/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit.csv;

import com.garmin.fit.BufferEncoder;
import com.garmin.fit.Decode;
import com.garmin.fit.Fit;
import com.garmin.fit.FitDecoder;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.csv.CSVDataMesgFieldCounter;
import com.garmin.fit.csv.CSVReader;
import com.garmin.fit.csv.MesgCSVWriter;
import com.garmin.fit.csv.MesgDataCSVWriter;
import com.garmin.fit.csv.MesgFilter;
import com.garmin.fit.plugins.ActivityFileValidationPlugin;
import com.garmin.fit.plugins.ActivityFileValidationResult;
import com.garmin.fit.util.StreamHelpers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class CSVTool {
    public boolean runningFromConsole = false;
    private final int DATA_OR_DEFINITION_SEARCH_COUNT = 2;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ByteArrayOutputStream dataWriterByteArrayOutputStream = null;
    private MesgDataCSVWriter dataMesgWriter = null;
    private MesgCSVWriter mesgWriter;
    private MesgFilter mesgFilter;
    private CSVDataMesgFieldCounter csvDataMesgFieldCounter;
    private int numUnknownFields = 0;
    private int numUnknownMesgs = 0;
    private final Decode decode = new Decode();
    private HashSet<String> mesgDefinitionsToOutput = new HashSet();
    private HashSet<String> dataMessagesToOutput = new HashSet();
    private boolean bytesAsHex = false;
    private boolean dateTimeAsISO8601 = false;
    private boolean semicirclesAsDegrees = false;
    private boolean verificationTests = false;
    private boolean checkIntegrity = false;
    private boolean showInvalidValues = false;
    private boolean showInvalidsAsEmpty = false;
    private boolean hideUnknownData = false;
    private boolean generateDataFile = false;
    private boolean enumsAsStrings = false;
    private boolean preserveGaps = false;
    private boolean removeExpandedFields = false;
    private boolean excludeMesgList = false;
    private Fit.ProtocolVersion protocolVersion = Fit.ProtocolVersion.V2_0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        String string;
        CSVTool cSVTool;
        block41: {
            cSVTool = new CSVTool();
            cSVTool.runningFromConsole = true;
            String string2 = null;
            string = null;
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            int n2 = 0;
            System.out.printf("FIT CSV Tool - Protocol %d.%d Profile %d.%d %s\n\n", Fit.PROTOCOL_VERSION_MAJOR, Fit.PROTOCOL_VERSION_MINOR, 21, 158, "Release");
            for (int i = 0; i < stringArray.length; ++i) {
                block40: {
                    block56: {
                        block55: {
                            block54: {
                                block53: {
                                    block52: {
                                        block50: {
                                            block51: {
                                                block49: {
                                                    block48: {
                                                        block47: {
                                                            block46: {
                                                                block45: {
                                                                    block44: {
                                                                        block43: {
                                                                            block42: {
                                                                                if (!stringArray[i].equals("-b")) break block42;
                                                                                if (stringArray.length - i < 3) {
                                                                                    CSVTool.printUsage();
                                                                                    return;
                                                                                }
                                                                                bl = true;
                                                                                string2 = stringArray[i + 1];
                                                                                string = stringArray[i + 2];
                                                                                i += 2;
                                                                                break block40;
                                                                            }
                                                                            if (!stringArray[i].equals("-c")) break block43;
                                                                            if (stringArray.length - i < 3) {
                                                                                CSVTool.printUsage();
                                                                                return;
                                                                            }
                                                                            bl2 = true;
                                                                            string2 = stringArray[i + 1];
                                                                            string = stringArray[i + 2];
                                                                            i += 2;
                                                                            break block40;
                                                                        }
                                                                        if (!stringArray[i].equals("-t")) break block44;
                                                                        cSVTool.enableVerificationTests(true);
                                                                        break block40;
                                                                    }
                                                                    if (!stringArray[i].equals("-d")) break block45;
                                                                    cSVTool.enableFitSdkDebugging(true);
                                                                    cSVTool.enableVerificationTests(true);
                                                                    break block40;
                                                                }
                                                                if (!stringArray[i].equals("-i")) break block46;
                                                                cSVTool.enableCheckIntegrity(true);
                                                                break block40;
                                                            }
                                                            if (!stringArray[i].equals("-ex")) break block47;
                                                            cSVTool.setExcludeMesgList(true);
                                                            break block40;
                                                        }
                                                        if (!stringArray[i].equals("--defn")) break block48;
                                                        n = cSVTool.DATA_OR_DEFINITION_SEARCH_COUNT;
                                                        break block40;
                                                    }
                                                    if (!stringArray[i].equals("--data")) break block49;
                                                    n2 = cSVTool.DATA_OR_DEFINITION_SEARCH_COUNT;
                                                    cSVTool.enableGenerateDataFile(true);
                                                    break block40;
                                                }
                                                if (stringArray[i].charAt(0) == '-') break block50;
                                                if (n <= 0) break block51;
                                                cSVTool.setMesgDefinitionFilter(new HashSet<String>(Arrays.asList(stringArray[i].toLowerCase().split(","))));
                                                break block40;
                                            }
                                            if (n2 > 0) {
                                                cSVTool.setDataMessagesFilter(new HashSet<String>(Arrays.asList(stringArray[i].toLowerCase().split(","))));
                                                break block40;
                                            } else {
                                                string2 = stringArray[i];
                                                if (string2.endsWith(".fit")) {
                                                    bl = true;
                                                    string = string2.substring(0, string2.length() - 4) + ".csv";
                                                    break block40;
                                                } else {
                                                    if (!string2.endsWith(".csv")) {
                                                        System.out.println("Invalid file provided " + string2 + " is not a .fit or .csv file");
                                                        CSVTool.printUsage();
                                                        return;
                                                    }
                                                    bl2 = true;
                                                    string = string2.substring(0, string2.length() - 4) + ".fit";
                                                }
                                            }
                                            break block40;
                                        }
                                        if (!stringArray[i].equals("-s")) break block52;
                                        cSVTool.enableShowInvalidValues(true);
                                        break block40;
                                    }
                                    if (!stringArray[i].equals("-se")) break block53;
                                    cSVTool.enableShowInvalidValues(true);
                                    cSVTool.enableShowInvalidsAsEmpty(true);
                                    break block40;
                                }
                                if (!stringArray[i].equals("-u")) break block54;
                                cSVTool.enableHideUnknownData(true);
                                break block40;
                            }
                            if (!stringArray[i].equals("-x")) break block55;
                            cSVTool.enableBytesAsHex(true);
                            break block40;
                        }
                        if (!stringArray[i].startsWith("-p")) break block56;
                        if (stringArray[i].endsWith("1")) {
                            cSVTool.setProtocolVersion(Fit.ProtocolVersion.V1_0);
                            break block40;
                        } else if (stringArray[i].endsWith("2")) {
                            cSVTool.setProtocolVersion(Fit.ProtocolVersion.V2_0);
                            break block40;
                        } else {
                            System.out.println("Unknown Protocol Version.");
                        }
                        break block40;
                    }
                    if (stringArray[i].equals("-e")) {
                        cSVTool.enableEnumsAsStrings(true);
                    } else if (stringArray[i].equals("-re")) {
                        cSVTool.enableRemoveExpandedFields(true);
                    } else if (stringArray[i].equals("-deg")) {
                        cSVTool.enableSemicirclesAsDegrees(true);
                    } else if (stringArray[i].equals("-iso8601")) {
                        cSVTool.enableDateTimeAsISO8601(true);
                    } else if (stringArray[i].equals("-g")) {
                        cSVTool.enablePreserveGaps(true);
                    }
                }
                if (n > 0 && --n == 0 && cSVTool.mesgDefinitionsToOutput.isEmpty()) {
                    System.out.println("No mesg definitions defined for --defn option.  Use 'none' if no definitions are desired.");
                    return;
                }
                if (n2 <= 0 || --n2 != 0 || !cSVTool.dataMessagesToOutput.isEmpty()) continue;
                System.out.println("No data messages defined for --data option.");
                return;
            }
            if (string2 == null || string2.isEmpty()) {
                System.out.println("No input file was provided!");
                CSVTool.printUsage();
                return;
            }
            File file = new File(string2);
            if (!file.exists()) {
                System.out.println("File does not exist: " + string2);
                return;
            }
            if (bl) {
                if (string.length() >= 4 && string.substring(string.length() - 4, string.length()).compareTo(".csv") == 0) {
                    string = string.substring(0, string.length() - 4);
                }
                System.out.printf("Decoding FIT binary file %s to %s*.csv files.\n", string2, string);
                try {
                    ByteArrayInputStream byteArrayInputStream = StreamHelpers.byteStreamFromFile(string2);
                    cSVTool.convertFitToCsv(byteArrayInputStream);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    System.out.printf("\n\nThere is insufficient memory available to process the file. Please increase the available memory by using the -Xmx<size> option when running the FIT CSV Tool.\ni.e. java -Xmx1G -jar FitCsvTool.jar %s\n", string2);
                }
                catch (Exception exception) {
                    System.out.printf("Error: A problem occurred while decoding the file. The decoded CSV file may be truncated %s*.csv files.\n", string);
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = cSVTool.getByteArrayOutputStream();
                    if (byteArrayOutputStream.toString().equals("")) {
                        if (cSVTool.getDataMessagesFilter().size() == 0 && cSVTool.getMesgDefinitionsFilter().size() == 0) {
                            System.out.println("Warning: No messages or message definitions found.");
                            return;
                        }
                        System.out.println("Warning: No filtered messages or filtered message definitions found.");
                        return;
                    }
                    StreamHelpers.writeByteStreamToFile(byteArrayOutputStream, string + ".csv", true);
                    if (cSVTool.isGenerateDataFileEnabled()) {
                        ByteArrayOutputStream byteArrayOutputStream2 = cSVTool.getDataWriterByteArrayOutputStream();
                        StreamHelpers.writeByteStreamToFile(byteArrayOutputStream2, string + "_data.csv", false);
                    }
                    if (!cSVTool.isHideUnknownDataEnabled()) return;
                    System.out.printf("Hid %d unknown field(s) and %d unknown message(s).\n", cSVTool.getNumUnknownFields(), cSVTool.getNumUnknownMesgs());
                    return;
                }
                catch (Exception exception) {
                    System.out.println("Error: A problem occurred while writing the output CSV files.");
                    return;
                }
            }
            if (!bl2) {
                CSVTool.printUsage();
                return;
            }
            if (string.length() >= 4 && string.substring(string.length() - 4, string.length()).compareTo(".fit") == 0) {
                string = string.substring(0, string.length() - 4);
            }
            System.out.printf("Encoding %s into FIT binary file %s.fit.\n", string2, string);
            try {
                ByteArrayInputStream byteArrayInputStream = StreamHelpers.byteStreamFromFile(string2);
                cSVTool.convertCsvToFit(byteArrayInputStream);
            }
            catch (Exception exception) {
                System.out.printf("Error: A problem occurred while encoding the file. The encoded FIT file %s.fit may be a truncated.\n", string);
                if (exception.getMessage() == null) break block41;
                System.out.println(exception.getMessage());
            }
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = cSVTool.getByteArrayOutputStream();
            StreamHelpers.writeByteStreamToFile(byteArrayOutputStream, string + ".fit", false);
            return;
        }
        catch (Exception exception) {
            System.out.println("Error: A problem occurred while writing the output FIT file.");
            return;
        }
    }

    public ByteArrayOutputStream convertFitToCsv(ByteArrayInputStream byteArrayInputStream) throws Exception {
        if (this.checkIntegrity) {
            if (!this.decode.checkFileIntegrity(byteArrayInputStream)) {
                if (!this.decode.getInvalidFileDataSize()) {
                    throw new FitRuntimeException("FIT file integrity failure.");
                }
                this.println("FIT file integrity failure. Invalid file size in header.");
                this.println("Trying to continue...");
            }
            byteArrayInputStream.reset();
        }
        if (this.verificationTests) {
            this.runVerificationTests(byteArrayInputStream);
        }
        try {
            this.setupCsvWriter();
            if (this.generateDataFile) {
                this.setupDataWriter();
            }
            if (this.showInvalidValues) {
                this.decode.showInvalidValues();
            }
            this.mesgFilter = new MesgFilter();
            this.csvDataMesgFieldCounter = new CSVDataMesgFieldCounter();
            if (this.excludeMesgList) {
                this.mesgFilter.setMesgDefinitionsToIgnore(this.mesgDefinitionsToOutput);
                this.mesgFilter.setDataMessagesToIgnore(this.dataMessagesToOutput);
            } else {
                this.mesgFilter.setMesgDefinitionsToOutput(this.mesgDefinitionsToOutput);
                this.mesgFilter.setDataMessagesToOutput(this.dataMessagesToOutput);
            }
            this.registerListenersForCsvWriter();
            this.registerListenersForDataWriter();
            while (this.decode.bytesAvailable(byteArrayInputStream)) {
                try {
                    this.decode.read(byteArrayInputStream);
                    this.decode.nextFile();
                }
                catch (FitRuntimeException fitRuntimeException) {
                    if (this.decode.getInvalidFileDataSize()) {
                        this.decode.nextFile();
                        continue;
                    }
                    throw fitRuntimeException;
                }
            }
            if (this.dataMesgWriter != null) {
                this.dataMesgWriter.setMaxNumFields(this.csvDataMesgFieldCounter.getMaxNumFields());
            }
            this.csvDataMesgFieldCounter.flushMesgs();
        }
        catch (IOException iOException) {
            if (this.isFitSdkDebugEnabled()) {
                iOException.printStackTrace(System.out);
            }
            throw iOException;
        }
        finally {
            this.numUnknownFields = this.mesgWriter.getNumUnknownFields();
            this.numUnknownMesgs = this.mesgWriter.getNumUnknownMesgs();
            this.cleanupCsvWriter();
            this.cleanupDataWriter();
        }
        return this.byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream convertCsvToFit(ByteArrayInputStream byteArrayInputStream) throws Exception {
        BufferEncoder bufferEncoder = new BufferEncoder(this.protocolVersion);
        try {
            if (!CSVReader.read(byteArrayInputStream, bufferEncoder, bufferEncoder, this.protocolVersion)) {
                throw new FitRuntimeException("FIT encoding error.");
            }
        }
        finally {
            byte[] byArray = bufferEncoder.close();
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.byteArrayOutputStream.write(byArray);
        }
        return this.byteArrayOutputStream;
    }

    private void setupCsvWriter() {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.mesgWriter = new MesgCSVWriter(this.byteArrayOutputStream);
        if (this.bytesAsHex) {
            this.mesgWriter.enableBytesAsHex(true);
        }
        if (this.dateTimeAsISO8601) {
            this.mesgWriter.enableDateTimeAsISO8601(true);
        }
        if (this.showInvalidsAsEmpty) {
            this.mesgWriter.enableShowInvalidsAsEmpty(true);
        }
        if (this.hideUnknownData) {
            this.mesgWriter.enableHideUnknownData(true);
        }
        if (this.enumsAsStrings) {
            this.mesgWriter.enableEnumsAsStrings(true);
        }
        if (this.removeExpandedFields) {
            this.mesgWriter.enableRemoveExpandedFields(true);
        }
        if (this.semicirclesAsDegrees) {
            this.mesgWriter.enableSemicirclesAsDegrees(true);
        }
    }

    private void setupDataWriter() {
        this.dataWriterByteArrayOutputStream = new ByteArrayOutputStream();
        this.dataMesgWriter = new MesgDataCSVWriter(this.dataWriterByteArrayOutputStream);
        if (this.bytesAsHex) {
            this.dataMesgWriter.enableBytesAsHex(true);
        }
        if (this.dateTimeAsISO8601) {
            this.dataMesgWriter.enableDateTimeAsISO8601(true);
        }
        if (this.showInvalidsAsEmpty) {
            this.dataMesgWriter.enableShowInvalidsAsEmpty(true);
        }
        if (this.hideUnknownData) {
            this.dataMesgWriter.enableHideUnknownData(true);
        }
        if (this.enumsAsStrings) {
            this.dataMesgWriter.enableEnumsAsStrings(true);
        }
        if (this.removeExpandedFields) {
            this.dataMesgWriter.enableRemoveExpandedFields(true);
        }
        if (this.semicirclesAsDegrees) {
            this.dataMesgWriter.enableSemicirclesAsDegrees(true);
        }
        if (this.preserveGaps) {
            this.dataMesgWriter.enablePreserveGaps(true);
        }
    }

    private void registerListenersForCsvWriter() {
        this.mesgFilter.addListener(this.mesgWriter);
        this.mesgFilter.addListener(this.mesgWriter);
        this.decode.addListener(this.mesgFilter);
        this.decode.addListener(this.mesgFilter);
    }

    private void registerListenersForDataWriter() {
        if (this.dataMesgWriter != null && this.csvDataMesgFieldCounter != null) {
            this.mesgFilter.addListener(this.csvDataMesgFieldCounter);
            this.csvDataMesgFieldCounter.addListener(this.dataMesgWriter);
        }
    }

    private void cleanupCsvWriter() {
        this.mesgWriter.close();
    }

    private void cleanupDataWriter() {
        if (this.dataMesgWriter != null) {
            this.dataMesgWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runVerificationTests(ByteArrayInputStream byteArrayInputStream) {
        block11: {
            ActivityFileValidationPlugin activityFileValidationPlugin;
            block10: {
                System.out.println("Running FIT verification tests...");
                activityFileValidationPlugin = new ActivityFileValidationPlugin();
                try {
                    FitDecoder fitDecoder = new FitDecoder();
                    fitDecoder.decode(byteArrayInputStream, activityFileValidationPlugin);
                    if (activityFileValidationPlugin.getResults().size() != 0) break block10;
                }
                catch (FitRuntimeException fitRuntimeException) {
                    System.out.println("FitRuntimeException decoding file: " + fitRuntimeException.getMessage());
                    break block11;
                }
                catch (Exception exception) {
                    System.out.println("Exception decoding file: " + exception.getMessage());
                    break block11;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (activityFileValidationPlugin.getResults().size() == 0) {
                        activityFileValidationPlugin.repeatValidation();
                    }
                    System.out.println("Message Count: " + activityFileValidationPlugin.getMesgCount());
                    for (ActivityFileValidationResult activityFileValidationResult : activityFileValidationPlugin.getResults()) {
                        System.out.println(activityFileValidationResult);
                        if (activityFileValidationResult.getDescription() == null) continue;
                        System.out.println("\t" + activityFileValidationResult.getDescription());
                    }
                    byteArrayInputStream.reset();
                }
                activityFileValidationPlugin.repeatValidation();
            }
            System.out.println("Message Count: " + activityFileValidationPlugin.getMesgCount());
            for (ActivityFileValidationResult activityFileValidationResult : activityFileValidationPlugin.getResults()) {
                System.out.println(activityFileValidationResult);
                if (activityFileValidationResult.getDescription() == null) continue;
                System.out.println("\t" + activityFileValidationResult.getDescription());
            }
            byteArrayInputStream.reset();
        }
    }

    private void println(String string) {
        if (this.runningFromConsole) {
            System.out.println(string);
        }
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.byteArrayOutputStream;
    }

    public ByteArrayOutputStream getDataWriterByteArrayOutputStream() {
        return this.dataWriterByteArrayOutputStream;
    }

    public void setProtocolVersion(Fit.ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public Fit.ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setMesgDefinitionFilter(HashSet<String> hashSet) {
        this.mesgDefinitionsToOutput = hashSet;
    }

    public HashSet<String> getMesgDefinitionsFilter() {
        return this.mesgDefinitionsToOutput;
    }

    public void setDataMessagesFilter(HashSet<String> hashSet) {
        this.dataMessagesToOutput = hashSet;
    }

    public HashSet<String> getDataMessagesFilter() {
        return this.dataMessagesToOutput;
    }

    public int getNumUnknownFields() {
        return this.numUnknownFields;
    }

    public int getNumUnknownMesgs() {
        return this.numUnknownMesgs;
    }

    public void enableHideUnknownData(boolean bl) {
        this.hideUnknownData = bl;
    }

    public boolean isHideUnknownDataEnabled() {
        return this.hideUnknownData;
    }

    public void enableGenerateDataFile(boolean bl) {
        this.generateDataFile = bl;
    }

    public boolean isGenerateDataFileEnabled() {
        return this.generateDataFile;
    }

    public void enableVerificationTests(boolean bl) {
        this.verificationTests = bl;
    }

    public boolean isVerificationTestsEnabled() {
        return this.verificationTests;
    }

    public void enableBytesAsHex(boolean bl) {
        this.bytesAsHex = bl;
    }

    public boolean isBytesAsHexEnabled() {
        return this.bytesAsHex;
    }

    public void enableDateTimeAsISO8601(boolean bl) {
        this.dateTimeAsISO8601 = bl;
    }

    public boolean isDateTimeAsISO8601Enabled() {
        return this.dateTimeAsISO8601;
    }

    public void enableSemicirclesAsDegrees(boolean bl) {
        this.semicirclesAsDegrees = bl;
    }

    public boolean isSemicirclesAsDegreesEnabled() {
        return this.semicirclesAsDegrees;
    }

    public void enableCheckIntegrity(boolean bl) {
        this.checkIntegrity = bl;
    }

    public boolean isCheckIntegrityEnabled() {
        return this.checkIntegrity;
    }

    public void enableShowInvalidValues(boolean bl) {
        this.showInvalidValues = bl;
    }

    public boolean isShowInvalidValuesEnabled() {
        return this.showInvalidValues;
    }

    public void enableShowInvalidsAsEmpty(boolean bl) {
        this.showInvalidsAsEmpty = bl;
        if (this.showInvalidsAsEmpty) {
            this.showInvalidValues = true;
        }
    }

    public boolean isShowInvalidsAsEmptyEnabled() {
        return this.showInvalidsAsEmpty;
    }

    public void enableEnumsAsStrings(boolean bl) {
        this.enumsAsStrings = bl;
    }

    public boolean isEnumsAsStringsEnabled() {
        return this.enumsAsStrings;
    }

    public void enablePreserveGaps(boolean bl) {
        this.preserveGaps = bl;
    }

    public boolean isPreserveGapsEnabled() {
        return this.preserveGaps;
    }

    public void enableRemoveExpandedFields(boolean bl) {
        this.removeExpandedFields = bl;
    }

    public boolean isRemoveExpandedFieldsEnabled() {
        return this.removeExpandedFields;
    }

    public void setExcludeMesgList(boolean bl) {
        this.excludeMesgList = bl;
    }

    public boolean isExcludeMesgListEnabled() {
        return this.excludeMesgList;
    }

    public void enableFitSdkDebugging(boolean bl) {
        Fit.debug = bl;
    }

    public boolean isFitSdkDebugEnabled() {
        return Fit.debug;
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar FitCSVTool.jar <options> <file>");
        System.out.println("      -b <FIT FILE> <CSV FILE>  FIT binary to CSV.");
        System.out.println("      -c <CSV FILE> <FIT FILE>  CSV to FIT binary.");
        System.out.println("      -t Enable file verification tests.");
        System.out.println("      -d Enable debug output.");
        System.out.println("      -i Check integrity of FIT file before decoding.");
        System.out.println("      -s Show invalid fields in the CSV file.");
        System.out.println("      -se Show invalid fields in the CSV file as empty cells.");
        System.out.println("      -u Hide unknown data and report statistics on how much is hidden.");
        System.out.println("      -x Print byte values as hexadecimal.");
        System.out.println("      -deg Print semicircle values as degrees.");
        System.out.println("      -iso8601 Print date-time values as ISO 8601 formatted strings.");
        System.out.println("      -ex Changes the behaviour of the --defn and --data options to");
        System.out.println("          filter out the messages listed. The default behaviour without");
        System.out.println("          this flag is to exclude all messages except those listed");
        System.out.println("          after the --defn and the --data options.");
        System.out.println("      -pN Encode file using Protocol Version <N>. Default: 2");
        System.out.println("      -e Print enum values as their corresponding String labels when");
        System.out.println("          possible. Note: CSV files generated with this option will not");
        System.out.println("          be able to be converted back into .FIT files.");
        System.out.println("      -re Remove expanded fields from CSV output. This removes fields");
        System.out.println("          that have been generated through component expansion and");
        System.out.println("          which do not exist in the source .FIT file");
        System.out.println("      --defn <MESSAGE_STRING_0,MESSAGE_STRING_1,...> Narrows down the");
        System.out.println("          definitions output to CSV. Use 'none' for no definitions");
        System.out.println("          When this option is used only the message definitions");
        System.out.println("          in the comma separated list will be written to the CSV.");
        System.out.println("          eg. --defn file_capabilities,record,file_creator");
        System.out.println("          Note: This option is only compatible with the -b option.");
        System.out.println("      --data <MESSAGE_STRING_0,MESSAGE_STRING_1,...> Narrows down the");
        System.out.println("          data output to CSV. When this option is used only the data");
        System.out.println("          in the comma separated list will be written to the csv.");
        System.out.println("          eg. --data file_capabilities,record,file_creator");
        System.out.println("          Note: This option is only compatible with the -b option.");
        System.out.println("      -g Preserve gaps caused by data dropouts. ");
        System.out.println("          Note: This option is only compatible with the --data option");
    }
}

