/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC16;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.ProtocolValidator;
import com.garmin.fit.ProtocolValidatorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.CheckedOutputStream;

public class FileEncoder
implements MesgListener,
MesgDefinitionListener {
    private File file;
    private CheckedOutputStream out;
    private CRC16 crc16;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];
    private Fit.ProtocolVersion version;
    private ProtocolValidator validator;

    public FileEncoder() {
    }

    @Deprecated
    public FileEncoder(File file) {
        this(file, Fit.ProtocolVersion.V1_0);
    }

    public FileEncoder(File file, Fit.ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
        this.validator = ProtocolValidatorFactory.getProtocolValidator(protocolVersion);
        this.open(file);
    }

    public void open(File file) {
        file.delete();
        this.crc16 = new CRC16();
        this.file = file;
        this.writeFileHeader();
        try {
            this.out = new CheckedOutputStream(new FileOutputStream(this.file, true), this.crc16);
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    private void writeFileHeader() {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        try {
            CRC16 cRC16 = new CRC16();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
            long l = this.file.length() - 14L;
            long l2 = 0L;
            if (l < 0L) {
                l = 0L;
            }
            byte[] byArray = new byte[]{14, (byte)this.version.getVersion(), -90, 82, (byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), 46, 70, 73, 84};
            randomAccessFile.write(byArray);
            cRC16.update(byArray, 0, byArray.length);
            l2 = cRC16.getValue();
            randomAccessFile.write((byte)(l2 & 0xFFL));
            randomAccessFile.write((byte)(l2 >> 8 & 0xFFL));
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void write(MesgDefinition mesgDefinition) {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        if (!this.validator.validateMesgDefn(mesgDefinition)) {
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        mesgDefinition.write(this.out);
        this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
    }

    public void write(Mesg mesg) {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        if (!this.validator.validateMesg(mesg)) {
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        if (this.lastMesgDefinition[mesg.localNum] == null || !this.lastMesgDefinition[mesg.localNum].supports(mesg)) {
            this.write(new MesgDefinition(mesg));
        }
        mesg.write(this.out, this.lastMesgDefinition[mesg.localNum]);
    }

    public void write(List<? extends Mesg> list) {
        for (Mesg mesg : list) {
            this.write(mesg);
        }
    }

    public void close() {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        try {
            this.writeFileHeader();
            long l = this.out.getChecksum().getValue();
            this.out.write((int)(l & 0xFFL));
            this.out.write((int)(l >> 8 & 0xFFL));
            this.out.close();
            this.file = null;
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }
}

