/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import java.io.IOException;
import java.io.OutputStream;

public class DeveloperFieldDefinition
extends FieldDefinitionBase {
    private FieldDescriptionMesg fieldDescriptionMesg;
    private DeveloperDataIdMesg developerDataIdMesg;
    private int size;
    private int type;
    private short num;

    public DeveloperFieldDefinition() {
        this.fieldDescriptionMesg = null;
        this.type = 2;
    }

    public DeveloperFieldDefinition(FieldDescriptionMesg fieldDescriptionMesg, DeveloperDataIdMesg developerDataIdMesg) {
        this.setFieldDescription(fieldDescriptionMesg);
        this.developerDataIdMesg = developerDataIdMesg;
    }

    public DeveloperFieldDefinition(DeveloperField developerField) {
        this(developerField.getFieldDefinition());
        this.size = developerField.getSize();
    }

    public DeveloperFieldDefinition(DeveloperFieldDefinition developerFieldDefinition) {
        this.setFieldDescription(developerFieldDefinition.fieldDescriptionMesg);
        this.developerDataIdMesg = developerFieldDefinition.developerDataIdMesg;
        this.size = developerFieldDefinition.getSize();
    }

    public long getAppVersion() {
        Long l = null;
        if (this.isDefined()) {
            l = this.developerDataIdMesg.getApplicationVersion();
        }
        if (null == l) {
            return Fit.UINT32_INVALID;
        }
        return l;
    }

    public Byte[] getAppId() {
        if (this.isDefined()) {
            return this.developerDataIdMesg.getApplicationId();
        }
        return null;
    }

    public short getDeveloperDataIndex() {
        Short s = null;
        if (this.isDefined()) {
            s = this.fieldDescriptionMesg.getDeveloperDataIndex();
        }
        if (null == s) {
            return Fit.UINT8_INVALID;
        }
        return s;
    }

    public boolean isDefined() {
        return this.fieldDescriptionMesg != null && this.developerDataIdMesg != null;
    }

    public String getFieldName() {
        if (this.isDefined()) {
            return this.fieldDescriptionMesg.getFieldName(0);
        }
        return null;
    }

    public short getScale() {
        if (this.isDefined() && this.fieldDescriptionMesg.getScale() != null && !this.fieldDescriptionMesg.getScale().equals(Fit.UINT8_INVALID)) {
            return this.fieldDescriptionMesg.getScale();
        }
        return 1;
    }

    public short getOffset() {
        if (this.isDefined() && this.fieldDescriptionMesg.getOffset() != null && !this.fieldDescriptionMesg.getOffset().equals(Fit.SINT8_INVALID)) {
            return this.fieldDescriptionMesg.getOffset().byteValue();
        }
        return 0;
    }

    public String getUnits() {
        if (this.isDefined()) {
            return this.fieldDescriptionMesg.getUnits(0);
        }
        return null;
    }

    public DeveloperField getDefaultField() {
        return new DeveloperField(this);
    }

    protected void write(OutputStream outputStream) {
        try {
            outputStream.write(this.fieldDescriptionMesg.getFieldDefinitionNumber().shortValue());
            outputStream.write(this.size);
            outputStream.write(this.fieldDescriptionMesg.getDeveloperDataIndex().shortValue());
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    public short getNum() {
        return this.num;
    }

    public void setNum(short s) {
        this.num = s;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setSize(int n) {
        this.size = n;
    }

    public int getType() {
        return this.type;
    }

    public short getNativeOverride() {
        Short s;
        if (this.isDefined() && null != (s = this.fieldDescriptionMesg.getNativeFieldNum())) {
            return s;
        }
        return Fit.UINT8_INVALID;
    }

    void setFieldDescription(FieldDescriptionMesg fieldDescriptionMesg) {
        this.fieldDescriptionMesg = fieldDescriptionMesg;
        this.num = this.fieldDescriptionMesg.getFieldDefinitionNumber();
        this.type = this.fieldDescriptionMesg.getFitBaseTypeId().shortValue();
    }

    void setDeveloperDataIdMesg(DeveloperDataIdMesg developerDataIdMesg) {
        this.developerDataIdMesg = developerDataIdMesg;
    }
}

