/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.DeveloperFieldDescription;
import com.garmin.fit.DeveloperFieldDescriptionListener;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.MesgSource;
import com.garmin.fit.Profile;
import com.garmin.fit.SubField;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class Decode
implements MesgSource {
    private static final long DECODE_DATA_RECORDS_ONLY = Long.MAX_VALUE;
    private static final int FIT_PROTOCOL_VERSION_ONE = 1;
    private static final int FIT_HEADER_SIZE_WITH_CRC = 14;
    private static final int FIT_HEADER_SIZE_NO_CRC = 12;
    private static boolean invalidDataSize = false;
    private boolean hasDevData;
    private static final int BUFFER_SIZE = 512;
    private STATE state;
    private byte fileHdrOffset;
    private byte fileHdrSize;
    private long fileDataSize;
    private long fileBytesLeft;
    private int crc;
    private Mesg mesg;
    private int localMesgIndex;
    private MesgDefinition[] localMesgDefs = new MesgDefinition[16];
    private HashMap<Short, DeveloperDataIdMesg> developerDataIds = new HashMap();
    private HashMap<Short, HashMap<Short, FieldDescriptionMesg>> developerFields = new HashMap();
    private int decoderMesgIndex = 0;
    private int numFields;
    private int fieldIndex;
    private int fieldDataIndex;
    private int fieldBytesLeft;
    private byte[] fieldData = new byte[255];
    private int lastTimeOffset;
    private long timestamp;
    private long systemTimeOffset = 0L;
    private Accumulator accumulator = new Accumulator();
    private boolean pause;
    private InputStream in;
    private boolean instreamIsComplete = true;
    private boolean invalidFileDataSize = false;
    private String headerException;
    private int currentByteOffset = 0;
    private ArrayList<MesgListener> mesgListeners = new ArrayList();
    private ArrayList<MesgDefinitionListener> mesgDefListeners = new ArrayList();
    private ArrayList<DeveloperFieldDescriptionListener> devFieldDescListeners = new ArrayList();
    private int bytesRead;
    private int currentByteIndex;
    private byte[] buffer;

    public Decode() {
        this.nextFile();
        this.bytesRead = 0;
        this.currentByteIndex = 0;
        this.buffer = new byte[512];
        if (Fit.debug) {
            System.out.printf("Fit.Decode: Starting decode...\n", new Object[0]);
        }
    }

    public boolean getInvalidFileDataSize() {
        return this.invalidFileDataSize;
    }

    public void setInvalidFileDataSize(boolean bl) {
        this.invalidFileDataSize = bl;
    }

    public void nextFile() {
        if (this.instreamIsComplete) {
            this.fileBytesLeft = 3L;
            this.fileHdrOffset = 0;
            this.crc = 0;
            this.state = STATE.FILE_HDR;
            this.lastTimeOffset = 0;
            this.pause = false;
            invalidDataSize = false;
            this.invalidFileDataSize = false;
            this.headerException = null;
        }
    }

    @Override
    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public void addListener(MesgDefinitionListener mesgDefinitionListener) {
        if (mesgDefinitionListener != null && !this.mesgDefListeners.contains(mesgDefinitionListener)) {
            this.mesgDefListeners.add(mesgDefinitionListener);
        }
    }

    public void addListener(DeveloperFieldDescriptionListener developerFieldDescriptionListener) {
        if (developerFieldDescriptionListener != null && !this.devFieldDescListeners.contains(developerFieldDescriptionListener)) {
            this.devFieldDescListeners.add(developerFieldDescriptionListener);
        }
    }

    public void setSystemTimeOffset(long l) {
        this.systemTimeOffset = l;
    }

    public void skipHeader() {
        if (this.in != null) {
            throw new FitRuntimeException("Can't set skipHeader option after Decode started!");
        }
        this.state = STATE.RECORD;
        this.fileBytesLeft = Long.MAX_VALUE;
    }

    public void incompleteStream() {
        if (this.in != null) {
            throw new FitRuntimeException("Can't set incompleteStream option after Decode started!");
        }
        this.instreamIsComplete = false;
    }

    public void showInvalidValues() {
        if (this.in != null) {
            throw new FitRuntimeException("Can't set showInvalidValues option after Decode started!");
        }
        FieldBase.forceShowInvalids = true;
    }

    public boolean read(InputStream inputStream, MesgListener mesgListener, MesgDefinitionListener mesgDefinitionListener) {
        boolean bl = true;
        this.addListener(mesgListener);
        this.addListener(mesgDefinitionListener);
        this.currentByteOffset = 0;
        try {
            while (this.bytesAvailable(inputStream) && bl) {
                bl = this.read(inputStream);
                this.nextFile();
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        return bl;
    }

    public boolean read(InputStream inputStream, MesgListener mesgListener) {
        this.addListener(mesgListener);
        return this.read(inputStream);
    }

    public boolean read(InputStream inputStream) {
        this.in = inputStream;
        return this.resume();
    }

    public void pause() {
        this.pause = true;
    }

    public boolean resume() {
        this.pause = false;
        RETURN rETURN = RETURN.CONTINUE;
        try {
            do {
                if (this.pause) {
                    return false;
                }
                while (this.currentByteIndex < this.bytesRead) {
                    rETURN = this.read(this.buffer[this.currentByteIndex]);
                    switch (rETURN) {
                        case CONTINUE: {
                            break;
                        }
                        case MESG: {
                            switch (this.mesg.num) {
                                case 207: {
                                    Object object = new DeveloperDataIdMesg(this.mesg);
                                    short s = ((DeveloperDataIdMesg)object).getDeveloperDataIndex();
                                    this.developerDataIds.put(s, (DeveloperDataIdMesg)object);
                                    this.developerFields.put(s, new HashMap());
                                    break;
                                }
                                case 206: {
                                    Object object = new FieldDescriptionMesg(this.mesg);
                                    short s = ((FieldDescriptionMesg)object).getDeveloperDataIndex();
                                    if (!this.developerFields.containsKey(s)) break;
                                    this.developerFields.get(s).put(((FieldDescriptionMesg)object).getFieldDefinitionNumber(), (FieldDescriptionMesg)object);
                                    DeveloperFieldDescription developerFieldDescription = new DeveloperFieldDescription(this.developerDataIds.get(s), (FieldDescriptionMesg)object);
                                    for (DeveloperFieldDescriptionListener developerFieldDescriptionListener : this.devFieldDescListeners) {
                                        developerFieldDescriptionListener.onDescription(developerFieldDescription);
                                    }
                                    break;
                                }
                            }
                            for (MesgListener mesgListener : this.mesgListeners) {
                                mesgListener.onMesg(this.mesg);
                            }
                            break;
                        }
                        case MESG_DEF: {
                            for (MesgDefinitionListener mesgDefinitionListener : this.mesgDefListeners) {
                                mesgDefinitionListener.onMesgDefinition(this.localMesgDefs[this.localMesgIndex]);
                            }
                            break;
                        }
                        case END_OF_FILE: {
                            ++this.currentByteIndex;
                            ++this.currentByteOffset;
                            return true;
                        }
                        default: {
                            ++this.currentByteOffset;
                            throw new FitRuntimeException("FIT decode error: " + (Object)((Object)rETURN) + " at byte: " + this.currentByteOffset);
                        }
                    }
                    ++this.currentByteOffset;
                    ++this.currentByteIndex;
                }
                this.currentByteIndex = 0;
            } while ((this.bytesRead = this.in.read(this.buffer, 0, this.buffer.length)) >= 0);
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        if (this.instreamIsComplete && this.fileBytesLeft != Long.MAX_VALUE) {
            throw new FitRuntimeException("FIT decode error: Unexpected end of input stream at byte: " + this.currentByteOffset);
        }
        if (!this.instreamIsComplete) {
            return rETURN == RETURN.MESG || rETURN == RETURN.MESG_DEF;
        }
        if (rETURN == RETURN.MESG || rETURN == RETURN.MESG_DEF) {
            return true;
        }
        if (!invalidDataSize || !this.invalidFileDataSize) {
            throw new FitRuntimeException("FIT decode error: Unexpected end of input stream at byte: " + this.currentByteOffset);
        }
        return true;
    }

    public boolean isFileFit(InputStream inputStream) {
        try {
            while (true) {
                if (this.currentByteIndex < this.bytesRead) {
                    switch (this.read(this.buffer[this.currentByteIndex])) {
                        case CONTINUE: 
                        case MESG: 
                        case MESG_DEF: {
                            break;
                        }
                        case END_OF_FILE: {
                            return true;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (this.state != STATE.FILE_HDR) {
                        return true;
                    }
                    ++this.currentByteIndex;
                    continue;
                }
                this.currentByteIndex = 0;
                this.bytesRead = inputStream.read(this.buffer, 0, this.buffer.length);
                if (this.bytesRead < 0) break;
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        catch (FitRuntimeException fitRuntimeException) {
            this.bytesRead = 0;
            this.currentByteIndex = 0;
        }
        return false;
    }

    public boolean checkFileIntegrity(InputStream inputStream) {
        boolean bl = true;
        try {
            while (true) {
                if (this.currentByteIndex < this.bytesRead) {
                    switch (this.read(this.buffer[this.currentByteIndex])) {
                        case CONTINUE: 
                        case MESG: 
                        case MESG_DEF: {
                            break;
                        }
                        case END_OF_FILE: {
                            this.nextFile();
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    ++this.currentByteIndex;
                    continue;
                }
                this.currentByteIndex = 0;
                this.bytesRead = inputStream.read(this.buffer, 0, this.buffer.length);
                if (this.bytesRead < 0) break;
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        catch (FitRuntimeException fitRuntimeException) {
            bl = false;
            if (this.getInvalidFileDataSize()) {
                this.nextFile();
            }
            this.bytesRead = 0;
            this.currentByteIndex = 0;
        }
        return bl;
    }

    public RETURN read(byte by) {
        if (Fit.debug) {
            if (this.fileBytesLeft == 2L) {
                System.out.printf("Fit.Decode: Expecting next 2 bytes to be end of file CRC = 0x%04X\n", this.crc);
            }
            System.out.printf("Fit.Decode: 0x%02X - %s\n", by & 0xFF, this.state.toString());
        }
        if (this.fileBytesLeft > 0L && this.fileBytesLeft != Long.MAX_VALUE) {
            this.crc = CRC.get16(this.crc, by);
            --this.fileBytesLeft;
            if (this.fileBytesLeft == 1L && this.state.ordinal() > STATE.FILE_HDR.ordinal()) {
                if (this.state != STATE.RECORD) {
                    throw new FitRuntimeException("FIT decode error: Decoder not in correct state after last data byte in file.  Check message definitions. Error at byte: " + this.currentByteOffset);
                }
                return RETURN.CONTINUE;
            }
            if (this.fileBytesLeft == 0L && this.state.ordinal() > STATE.FILE_HDR.ordinal()) {
                if (this.crc != 0) {
                    throw new FitRuntimeException("FIT decode error: File CRC failed. Error at byte: " + this.currentByteOffset);
                }
                return RETURN.END_OF_FILE;
            }
        }
        switch (this.state) {
            case FILE_HDR: {
                byte by2 = this.fileHdrOffset;
                this.fileHdrOffset = (byte)(by2 + 1);
                switch (by2) {
                    case 0: {
                        if (by == 0) {
                            ++this.fileBytesLeft;
                            this.fileHdrOffset = 0;
                            this.headerException = null;
                            this.crc = 0;
                            break;
                        }
                        if (by < 12) {
                            this.headerException = "FIT decode error: Header size is invalid. Error at byte: " + this.currentByteOffset;
                            break;
                        }
                        this.fileHdrSize = by;
                        this.fileBytesLeft = this.fileHdrSize + 2;
                        break;
                    }
                    case 1: {
                        if ((by & 0xF0) <= Fit.PROTOCOL_VERSION_MAJOR << 4) break;
                        this.headerException = "FIT decode error: Protocol version " + ((by & 0xF0) >> 4) + "." + (by & 0xF) + " not supported.  Must be " + Fit.PROTOCOL_VERSION_MAJOR + "." + Fit.PROTOCOL_VERSION_MINOR + " or earlier.";
                        break;
                    }
                    case 4: {
                        this.fileDataSize = by & 0xFF;
                        break;
                    }
                    case 5: {
                        this.fileDataSize |= (long)(by & 0xFF) << 8;
                        break;
                    }
                    case 6: {
                        this.fileDataSize |= (long)(by & 0xFF) << 16;
                        break;
                    }
                    case 7: {
                        this.fileDataSize |= (long)(by & 0xFF) << 24;
                        if (this.fileDataSize != 0L || invalidDataSize && this.invalidFileDataSize) break;
                        invalidDataSize = true;
                        this.invalidFileDataSize = true;
                        this.headerException = "FIT decode error: File Size is 0. Error at byte: " + this.currentByteOffset;
                        break;
                    }
                    case 8: {
                        if (by == 46) break;
                        this.headerException = "FIT decode error: File is not FIT format.  Check file header data type. Error at byte: " + this.currentByteOffset;
                        break;
                    }
                    case 9: {
                        if (by == 70) break;
                        this.headerException = "FIT decode error: File is not FIT format.  Check file header data type. Error at byte: " + this.currentByteOffset;
                        break;
                    }
                    case 10: {
                        if (by == 73) break;
                        this.headerException = "FIT decode error: File is not FIT format.  Check file header data type. Error at byte: " + this.currentByteOffset;
                        break;
                    }
                    case 11: {
                        if (by != 84) {
                            this.headerException = "FIT decode error: File is not FIT format.  Check file header data type. Error at byte: " + this.currentByteOffset;
                        }
                        if (this.headerException == null || this.fileHdrSize != 12) break;
                        throw new FitRuntimeException(this.headerException);
                    }
                    case 12: {
                        break;
                    }
                    case 13: {
                        if (this.headerException == null) break;
                        ++this.currentByteIndex;
                        throw new FitRuntimeException(this.headerException);
                    }
                }
                if (this.fileHdrOffset != this.fileHdrSize || this.fileHdrSize == 0) break;
                this.fileBytesLeft = invalidDataSize && this.invalidFileDataSize ? Long.MAX_VALUE : this.fileDataSize + 2L;
                this.state = STATE.RECORD;
                break;
            }
            case RECORD: {
                this.fieldIndex = 0;
                this.fieldBytesLeft = 0;
                if (this.fileBytesLeft > 1L) {
                    if ((by & 0x80) != 0) {
                        int n = by & 0x1F;
                        this.localMesgIndex = (by & 0x60) >> 5;
                        if (this.localMesgDefs[this.localMesgIndex] == null) {
                            throw new FitRuntimeException("FIT decode error: Missing message definition for local message number " + this.localMesgIndex + ". Error at byte: " + this.currentByteOffset);
                        }
                        Field field = Factory.createField(this.localMesgDefs[this.localMesgIndex].num, 253);
                        this.timestamp += (long)(n - this.lastTimeOffset & 0x1F);
                        this.lastTimeOffset = n;
                        field.setValue(this.timestamp);
                        this.mesg = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                        this.mesg.localNum = this.localMesgIndex;
                        this.mesg.systemTimeOffset = this.systemTimeOffset;
                        this.mesg.setDecoderMessageIndex(this.decoderMesgIndex++);
                        this.mesg.addField(field);
                        if (this.localMesgDefs[this.localMesgIndex].fields.size() != 0) {
                            this.state = STATE.FIELD_DATA;
                            break;
                        }
                        if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                            this.state = STATE.DEV_FIELD_DATA;
                            break;
                        }
                        return RETURN.MESG;
                    }
                    this.localMesgIndex = by & 0xF;
                    if ((by & 0x40) != 0) {
                        this.localMesgDefs[this.localMesgIndex] = new MesgDefinition();
                        this.localMesgDefs[this.localMesgIndex].localNum = this.localMesgIndex;
                        this.hasDevData = false;
                        if ((by & 0x20) != 0) {
                            this.hasDevData = true;
                        }
                        this.state = STATE.RESERVED1;
                        break;
                    }
                    if (this.localMesgDefs[this.localMesgIndex] == null) {
                        throw new FitRuntimeException("FIT decode error: Missing message definition for local message number " + this.localMesgIndex + ". Error at byte: " + this.currentByteOffset);
                    }
                    this.mesg = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                    this.mesg.localNum = this.localMesgIndex;
                    this.mesg.systemTimeOffset = this.systemTimeOffset;
                    this.mesg.setDecoderMessageIndex(this.decoderMesgIndex++);
                    if (this.localMesgDefs[this.localMesgIndex].fields.size() != 0) {
                        this.state = STATE.FIELD_DATA;
                        break;
                    }
                    if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                        this.state = STATE.DEV_FIELD_DATA;
                        break;
                    }
                    return RETURN.MESG;
                }
                this.state = STATE.FILE_CRC_HIGH;
                break;
            }
            case RESERVED1: {
                this.state = STATE.ARCH;
                break;
            }
            case ARCH: {
                this.localMesgDefs[this.localMesgIndex].arch = by & 0xFF;
                this.state = STATE.MESG_NUM_0;
                break;
            }
            case MESG_NUM_0: {
                this.localMesgDefs[this.localMesgIndex].num = by & 0xFF;
                this.state = STATE.MESG_NUM_1;
                break;
            }
            case MESG_NUM_1: {
                this.localMesgDefs[this.localMesgIndex].num |= (by & 0xFF) << 8;
                if (this.localMesgDefs[this.localMesgIndex].arch == 1) {
                    this.localMesgDefs[this.localMesgIndex].num = this.localMesgDefs[this.localMesgIndex].num >> 8 | (this.localMesgDefs[this.localMesgIndex].num & 0xFF) << 8;
                } else if (this.localMesgDefs[this.localMesgIndex].arch != 0) {
                    throw new FitRuntimeException("FIT decode error: Endian " + this.localMesgDefs[this.localMesgIndex].arch + " not supported. Error at byte: " + this.currentByteOffset);
                }
                this.state = STATE.NUM_FIELDS;
                break;
            }
            case NUM_FIELDS: {
                this.numFields = by & 0xFF;
                if (this.numFields == 0) {
                    if (this.hasDevData) {
                        this.state = STATE.NUM_DEV_FIELDS;
                        break;
                    }
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case FIELD_NUM: {
                this.localMesgDefs[this.localMesgIndex].fields.add(new FieldDefinition());
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).num = by & 0xFF;
                this.state = STATE.FIELD_SIZE;
                break;
            }
            case FIELD_SIZE: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).size = by & 0xFF;
                this.state = STATE.FIELD_TYPE;
                break;
            }
            case FIELD_TYPE: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).type = by & 0xFF;
                if (++this.fieldIndex >= this.numFields) {
                    if (this.hasDevData) {
                        this.state = STATE.NUM_DEV_FIELDS;
                        break;
                    }
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case NUM_DEV_FIELDS: {
                this.fieldIndex = 0;
                this.numFields = by & 0xFF;
                if (this.numFields == 0) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.DEV_FIELD_NUM;
                break;
            }
            case DEV_FIELD_NUM: {
                this.localMesgDefs[this.localMesgIndex].developerFields.add(new DeveloperFieldDefinition());
                this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex).setNum((short)(by & 0xFF));
                this.state = STATE.DEV_FIELD_SIZE;
                break;
            }
            case DEV_FIELD_SIZE: {
                this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex).setSize(by & 0xFF);
                this.state = STATE.DEV_FIELD_DEV_ID;
                break;
            }
            case DEV_FIELD_DEV_ID: {
                DeveloperFieldDefinition developerFieldDefinition = this.localMesgDefs[this.localMesgIndex].developerFields.get(this.fieldIndex);
                short s = by;
                if (this.developerFields.containsKey(s)) {
                    developerFieldDefinition.setDeveloperDataIdMesg(this.developerDataIds.get(s));
                    if (this.developerFields.get(s).containsKey(developerFieldDefinition.getNum())) {
                        FieldDescriptionMesg fieldDescriptionMesg = this.developerFields.get(s).get(developerFieldDefinition.getNum());
                        developerFieldDefinition.setFieldDescription(fieldDescriptionMesg);
                    }
                }
                if (++this.fieldIndex >= this.numFields) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.DEV_FIELD_NUM;
                break;
            }
            case FIELD_DATA: {
                int n;
                FieldDefinition fieldDefinition = this.localMesgDefs[this.localMesgIndex].fields.get(this.fieldIndex);
                while (this.fieldBytesLeft == 0) {
                    this.fieldDataIndex = 0;
                    this.fieldBytesLeft = fieldDefinition.size;
                    if (this.fieldBytesLeft != 0) continue;
                    if (this.fieldIndex + 1 >= this.localMesgDefs[this.localMesgIndex].fields.size()) break;
                    fieldDefinition = this.localMesgDefs[this.localMesgIndex].fields.get(++this.fieldIndex);
                }
                this.fieldData[this.fieldDataIndex++] = by;
                --this.fieldBytesLeft;
                if (this.fieldBytesLeft != 0) break;
                boolean bl = true;
                if ((fieldDefinition.type & 0x1F) < 17) {
                    Field field;
                    int n2 = Fit.baseTypeSizes[fieldDefinition.type & 0x1F];
                    int n3 = fieldDefinition.size / n2;
                    if ((fieldDefinition.type & 0x80) != 0 && (this.localMesgDefs[this.localMesgIndex].arch & 1) != 1) {
                        this.FlipFieldDataByteOrder(n2, n3);
                    }
                    if ((field = Factory.createField(this.mesg.num, fieldDefinition.num)) != null) {
                        Long l;
                        if (field.getName().equals("unknown")) {
                            field = new Field("unknown", fieldDefinition.num, fieldDefinition.type, 1.0, 0.0, "", false, Profile.Type.fromBaseType(fieldDefinition.type));
                        }
                        if (field.type != fieldDefinition.type) {
                            n = Fit.baseTypeSizes[field.type & 0x1F];
                            if (n2 < n) {
                                field.type = fieldDefinition.type;
                            } else if (n2 != n) {
                                bl = false;
                            }
                        }
                        if (bl) {
                            field.read(new ByteArrayInputStream(this.fieldData), fieldDefinition.size);
                        }
                        if (fieldDefinition.num == 253 && (l = field.getLongValue()) != null) {
                            this.timestamp = l;
                            this.lastTimeOffset = (int)(this.timestamp & 0x1FL);
                        }
                        if (field.getIsAccumulated()) {
                            for (n = 0; n < field.getNumValues(); ++n) {
                                long l2 = ((Number)field.getRawValue(n)).longValue();
                                for (Field field2 : this.mesg.fields) {
                                    for (FieldComponent fieldComponent : field2.components) {
                                        if (fieldComponent.fieldNum != field.num || !fieldComponent.accumulate) continue;
                                        l2 = (long)(((double)l2 / field.scale - field.offset + fieldComponent.offset) * fieldComponent.scale);
                                    }
                                }
                                this.accumulator.set(this.mesg.num, field.getNum(), l2);
                            }
                        }
                        if (field.getNumValues() > 0) {
                            this.mesg.addField(field);
                        }
                    }
                }
                ++this.fieldIndex;
                if (this.fieldIndex < this.localMesgDefs[this.localMesgIndex].fields.size()) break;
                for (n = 0; n < this.mesg.fields.size(); ++n) {
                    int n4 = this.mesg.getActiveSubFieldIndex(this.mesg.fields.get(n).getNum());
                    if (n4 == 65535) {
                        if (this.mesg.fields.get((int)n).components.size() <= 0) continue;
                        this.expandComponents(this.mesg.fields.get(n), this.mesg.fields.get((int)n).components);
                        continue;
                    }
                    if (this.mesg.fields.get((int)n).subFields.get((int)n4).components.size() <= 0) continue;
                    this.expandComponents(this.mesg.fields.get(n), this.mesg.fields.get((int)n).subFields.get((int)n4).components);
                }
                if (this.localMesgDefs[this.localMesgIndex].getDeveloperFieldTotalSize() > 0) {
                    this.fieldIndex = 0;
                    this.fieldBytesLeft = 0;
                    this.state = STATE.DEV_FIELD_DATA;
                    break;
                }
                this.state = STATE.RECORD;
                return RETURN.MESG;
            }
            case DEV_FIELD_DATA: {
                MesgDefinition mesgDefinition = this.localMesgDefs[this.localMesgIndex];
                DeveloperFieldDefinition developerFieldDefinition = mesgDefinition.developerFields.get(this.fieldIndex);
                while (this.fieldBytesLeft == 0) {
                    this.fieldDataIndex = 0;
                    this.fieldBytesLeft = developerFieldDefinition.getSize();
                    if (this.fieldBytesLeft != 0) continue;
                    if (this.fieldIndex + 1 >= this.localMesgDefs[this.localMesgIndex].developerFields.size()) break;
                    this.fieldBytesLeft = this.localMesgDefs[this.localMesgIndex].developerFields.get(++this.fieldIndex).getSize();
                }
                this.fieldData[this.fieldDataIndex++] = by;
                --this.fieldBytesLeft;
                if (this.fieldBytesLeft != 0) break;
                DeveloperField developerField = new DeveloperField(developerFieldDefinition);
                if ((developerFieldDefinition.getType() & 0x1F) < 17) {
                    int n = Fit.baseTypeSizes[developerFieldDefinition.getType() & 0x1F];
                    int n5 = developerFieldDefinition.getSize() / n;
                    if ((developerFieldDefinition.getType() & 0x80) != 0 && (mesgDefinition.arch & 1) != 1) {
                        this.FlipFieldDataByteOrder(n, n5);
                    }
                    developerField.read(new ByteArrayInputStream(this.fieldData), developerFieldDefinition.getSize());
                    if (developerField.getNumValues() > 0) {
                        this.mesg.addDeveloperField(developerField);
                    }
                }
                ++this.fieldIndex;
                if (this.fieldIndex < mesgDefinition.developerFields.size()) break;
                this.state = STATE.RECORD;
                return RETURN.MESG;
            }
        }
        return RETURN.CONTINUE;
    }

    private void FlipFieldDataByteOrder(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n / 2; ++j) {
                byte by = this.fieldData[i * n + j];
                this.fieldData[i * n + j] = this.fieldData[i * n + n - j - 1];
                this.fieldData[i * n + n - j - 1] = by;
            }
        }
    }

    protected void expandComponents(Field field, ArrayList<FieldComponent> arrayList) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            FieldComponent fieldComponent = arrayList.get(i);
            if (fieldComponent.fieldNum != 255) {
                Double d;
                Field field2 = Factory.createField(this.mesg.num, fieldComponent.fieldNum);
                int n2 = this.mesg.getActiveSubFieldIndex(fieldComponent.fieldNum);
                SubField subField = field2.getSubField(n2);
                field2.setIsExpanded(true);
                Long l = field.getBitsValue(n, fieldComponent.bits, field2.isSignedInteger());
                if (l == null) break;
                if (fieldComponent.accumulate) {
                    l = this.accumulator.accumulate(this.mesg.num, fieldComponent.fieldNum, l, fieldComponent.bits);
                }
                if (field2.components.size() == 1) {
                    d = ((double)l.longValue() / fieldComponent.scale - fieldComponent.offset + field2.components.get((int)0).offset) * field2.components.get((int)0).scale;
                    if (this.mesg.hasField(field2.num)) {
                        this.mesg.getField(field2.num).addRawValue(d);
                    } else {
                        field2.addRawValue(d);
                        this.mesg.addField(field2);
                    }
                } else if (field2.components.size() > 1) {
                    for (int j = 0; j < fieldComponent.bits; j += Fit.baseTypeSizes[field2.type & 0x1F]) {
                        long l2 = (1L << Fit.baseTypeSizes[field2.type & 0x1F]) - 1L;
                        if (this.mesg.hasField(field2.num)) {
                            this.mesg.getField(field2.num).addValue(l & l2);
                        } else {
                            field2.addValue(l & l2);
                            this.mesg.addField(field2);
                        }
                        l = l >>> Fit.baseTypeSizes[field2.type & 0x1F];
                    }
                } else {
                    d = subField == null ? Double.valueOf(((double)l.longValue() / fieldComponent.scale - fieldComponent.offset + field2.offset) * field2.scale) : Double.valueOf(((double)l.longValue() / fieldComponent.scale - fieldComponent.offset + subField.offset) * subField.scale);
                    if (this.mesg.hasField(field2.num)) {
                        this.mesg.getField(field2.num).addRawValue(d);
                    } else {
                        field2.addRawValue(d);
                        this.mesg.addField(field2);
                    }
                }
            }
            n += fieldComponent.bits;
        }
    }

    public Mesg getMesg() {
        return this.mesg;
    }

    public boolean bytesAvailable(InputStream inputStream) throws IOException {
        boolean bl = false;
        if (this.currentByteIndex > 0 && this.currentByteIndex < this.bytesRead) {
            bl = true;
        } else if (inputStream.available() > 0) {
            bl = true;
        }
        return bl;
    }

    private class Accumulator {
        ArrayList<AccumulatedField> accumulatedFields = new ArrayList();

        Accumulator() {
        }

        public void set(int n, int n2, long l) {
            int n3;
            AccumulatedField accumulatedField = null;
            for (n3 = 0; n3 < this.accumulatedFields.size(); ++n3) {
                accumulatedField = this.accumulatedFields.get(n3);
                if (accumulatedField.mesgNum == n && accumulatedField.destFieldNum == n2) break;
            }
            if (n3 == this.accumulatedFields.size()) {
                accumulatedField = new AccumulatedField(n, n2);
                this.accumulatedFields.add(accumulatedField);
            }
            accumulatedField.set(l);
        }

        public long accumulate(int n, int n2, long l, int n3) {
            int n4;
            AccumulatedField accumulatedField = null;
            for (n4 = 0; n4 < this.accumulatedFields.size(); ++n4) {
                accumulatedField = this.accumulatedFields.get(n4);
                if (accumulatedField.mesgNum == n && accumulatedField.destFieldNum == n2) break;
            }
            if (n4 == this.accumulatedFields.size()) {
                accumulatedField = new AccumulatedField(n, n2);
                this.accumulatedFields.add(accumulatedField);
            }
            return accumulatedField.accumulate(l, n3);
        }
    }

    private class AccumulatedField {
        int mesgNum;
        int destFieldNum;
        long lastValue;
        long accumulatedValue;

        AccumulatedField(int n, int n2) {
            this.mesgNum = n;
            this.destFieldNum = n2;
            this.lastValue = 0L;
            this.accumulatedValue = 0L;
        }

        public long accumulate(long l, int n) {
            long l2 = (1L << n) - 1L;
            this.accumulatedValue += l - this.lastValue & l2;
            this.lastValue = l;
            return this.accumulatedValue;
        }

        public long set(long l) {
            this.accumulatedValue = l;
            this.lastValue = l;
            return this.accumulatedValue;
        }
    }

    private static enum STATE {
        FILE_HDR,
        RECORD,
        RESERVED1,
        ARCH,
        MESG_NUM_0,
        MESG_NUM_1,
        NUM_FIELDS,
        FIELD_NUM,
        FIELD_SIZE,
        FIELD_TYPE,
        NUM_DEV_FIELDS,
        DEV_FIELD_NUM,
        DEV_FIELD_SIZE,
        DEV_FIELD_DEV_ID,
        FIELD_DATA,
        DEV_FIELD_DATA,
        FILE_CRC_HIGH;

    }

    public static enum RETURN {
        CONTINUE,
        MESG,
        MESG_DEF,
        END_OF_FILE;

    }
}

